# 機能設計書 6-next lint

## 概要

本ドキュメントは、Next.jsのESLintによるコード品質チェックコマンド `next lint` の機能設計を記述する。eslint-plugin-nextと連携し、Next.js固有のベストプラクティスに基づくコード品質チェックを提供する。

### 本機能の処理概要

`next lint` コマンドは、ESLintを使用してNext.jsプロジェクトのコード品質チェックを実行するCLIコマンドである。現行バージョンでは、CLIのメインエントリーポイント（bin/next.ts）から直接のコマンド登録が確認されず、ビルドプロセスの一部として統合されている可能性がある。ESLintプラグイン（`@next/eslint-plugin-next`）は独立パッケージとして提供されている。

**業務上の目的・背景**：Next.jsアプリケーション開発において、フレームワーク固有のベストプラクティスに従ったコーディングを自動的にチェックすることで、パフォーマンス劣化やセキュリティリスクを未然に防ぐ。`<img>`要素の代わりに`next/image`を使用するルールや、Google Fontsの最適化ルールなど、Next.js特有の最適化を促進する。

**機能の利用シーン**：開発中のコードレビュー時、CI/CDパイプラインでの自動チェック時、またはエディタのESLint統合を通じてリアルタイムにフィードバックを受ける際に使用する。

**主要な処理内容**：
1. ESLintプラグインによるNext.js固有ルールの適用
2. recommendedルールセット（警告レベル15ルール + エラーレベル6ルール）の提供
3. core-web-vitalsルールセット（パフォーマンス重視の追加ルール）の提供
4. レガシー設定（.eslintrc）とFlat Config（eslint.config.js）の両方をサポート

**関連システム・外部連携**：ESLint、eslint-config-next

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 関連画面なし（CLIコンソール出力のみ） |

## 機能種別

CLIコマンド / 静的解析 / コード品質チェック

## 入力仕様

### 入力パラメータ

ESLintプラグインとして利用する場合、ESLintの標準的な設定ファイルを通じて設定する。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ESLint設定ファイル | file | Yes | .eslintrc.* または eslint.config.js | ESLintの設定形式に準拠 |
| 対象ファイル | path | Yes | リント対象のファイルパス | 存在するファイル/ディレクトリ |

### 入力データソース

- ESLint設定ファイル
- プロジェクトのソースコード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リント結果 | text | ESLint標準形式のリント結果（エラー・警告の一覧） |
| 終了コード | number | 0: 問題なし、1: エラーあり |

### 出力先

- 標準出力（リント結果）

## 処理フロー

### 処理シーケンス

```
1. ESLintプラグインの読み込み
   └─ @next/eslint-plugin-nextの各ルールモジュールをインポート
2. ルールセットの構築
   └─ recommendedルール（21ルール）とcore-web-vitalsルール（2ルール追加）の定義
3. 設定の適用
   └─ レガシーConfig（recommended-legacy / core-web-vitals-legacy）
   └─ Flat Config（recommended / core-web-vitals）
4. ESLintによるファイル解析
   └─ 各ファイルに対してルールを適用
5. 結果の出力
   └─ ESLint標準形式で結果を表示
```

### フローチャート

```mermaid
flowchart TD
    A[ESLint実行] --> B[プラグイン読み込み]
    B --> C[ルールセット選択]
    C --> D{recommended or core-web-vitals?}
    D -->|recommended| E[15警告 + 6エラールール適用]
    D -->|core-web-vitals| F[recommended + 2エラールール追加]
    E --> G[ファイル解析]
    F --> G
    G --> H[結果出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | recommendedルール | 15の警告ルール + 6のエラールールを含む標準ルールセット | plugin:@next/next/recommended使用時 |
| BR-02 | core-web-vitalsルール | recommendedに加え、no-html-link-for-pagesとno-sync-scriptsをエラーレベルに昇格 | plugin:@next/next/core-web-vitals使用時 |
| BR-03 | 警告レベルルール | google-font-display, no-img-element, no-head-element等15ルールはwarnレベル | recommended設定時 |
| BR-04 | エラーレベルルール | inline-script-id, no-assign-module-variable, no-document-import-in-page等6ルールはerrorレベル | recommended設定時 |

### ESLintルール一覧

**警告（warn）レベル:**
- google-font-display
- google-font-preconnect
- next-script-for-ga
- no-async-client-component
- no-before-interactive-script-outside-document
- no-css-tags
- no-head-element
- no-html-link-for-pages
- no-img-element
- no-page-custom-font
- no-styled-jsx-in-document
- no-sync-scripts
- no-title-in-document-head
- no-typos
- no-unwanted-polyfillio

**エラー（error）レベル:**
- inline-script-id
- no-assign-module-variable
- no-document-import-in-page
- no-duplicate-head
- no-head-import-in-document
- no-script-component-in-head

### 計算ロジック

なし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ESLint設定エラー | 設定ファイルの構文エラー | ESLint設定を修正 |
| - | ルール違反（error） | コードがエラーレベルのルールに違反 | コードを修正 |
| - | ルール違反（warn） | コードが警告レベルのルールに違反 | コードの改善を推奨 |

### リトライ仕様

なし。

## トランザクション仕様

なし。

## パフォーマンス要件

- プロジェクトの規模に応じてリント実行時間が増加する
- ESLintのキャッシュ機能（--cache）を利用することで再実行時の性能を向上できる

## セキュリティ考慮事項

- ESLintルール自体がセキュリティ関連のチェックを含む（no-document-import-in-page等）
- カスタムルールの導入には信頼できるソースからのプラグインのみを使用すべき

## 備考

- 現行バージョンのCLIメインエントリーポイント（bin/next.ts）には`next lint`コマンドの直接的な登録が確認されていない。ESLintプラグインとして`@next/eslint-plugin-next`パッケージが提供されており、プロジェクトのESLint設定を通じて利用する形態となっている。
- Flat Config（eslint.config.js）とレガシーConfig（.eslintrc）の両方をサポート
- eslint-config-nextパッケージがプリセット設定を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プラグインのエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.ts | `packages/eslint-plugin-next/src/index.ts` | プラグインのメインエクスポート。全ルールのインポートとルールセットの定義 |

**主要処理フロー**:
1. **1-23行目**: 21個のルールモジュールのインポート
2. **25-49行目**: recommendedRulesの定義（15 warn + 6 error）
3. **51-54行目**: coreWebVitalsRulesの定義（2ルールをerrorに昇格）
4. **56-85行目**: pluginオブジェクトの構築（meta, rules, configs）
5. **94-121行目**: 4つの設定プリセット（recommended-legacy, core-web-vitals-legacy, recommended, core-web-vitals）

**読解のコツ**: `satisfies`キーワードはTypeScript 4.9の機能で、型の互換性チェックを行いつつ推論された型を保持する。Linter.RulesRecordやESLintPluginConfigs型との整合性を確保している。

#### Step 2: 個別ルールの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | no-img-element.ts | `packages/eslint-plugin-next/src/rules/no-img-element.ts` | 代表的なルールの実装パターン |
| 2-2 | no-html-link-for-pages.ts | `packages/eslint-plugin-next/src/rules/no-html-link-for-pages.ts` | ページディレクトリ参照を含むルール |
| 2-3 | define-rule.ts | `packages/eslint-plugin-next/src/utils/define-rule.ts` | ルール定義のヘルパーユーティリティ |

#### Step 3: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node-attributes.ts | `packages/eslint-plugin-next/src/utils/node-attributes.ts` | ASTノードの属性操作ユーティリティ |
| 3-2 | url.ts | `packages/eslint-plugin-next/src/utils/url.ts` | URL処理ユーティリティ |
| 3-3 | get-root-dirs.ts | `packages/eslint-plugin-next/src/utils/get-root-dirs.ts` | プロジェクトルートディレクトリの取得 |

### プログラム呼び出し階層図

```
ESLint ランタイム
    │
    └─ @next/eslint-plugin-next (プラグイン)
           │
           ├─ index.ts (エントリーポイント)
           │      ├─ rules/ (21個のルール)
           │      │      ├─ google-font-display.ts
           │      │      ├─ google-font-preconnect.ts
           │      │      ├─ inline-script-id.ts
           │      │      ├─ next-script-for-ga.ts
           │      │      ├─ no-assign-module-variable.ts
           │      │      ├─ no-async-client-component.ts
           │      │      ├─ no-before-interactive-script-outside-document.ts
           │      │      ├─ no-css-tags.ts
           │      │      ├─ no-document-import-in-page.ts
           │      │      ├─ no-duplicate-head.ts
           │      │      ├─ no-head-element.ts
           │      │      ├─ no-head-import-in-document.ts
           │      │      ├─ no-html-link-for-pages.ts
           │      │      ├─ no-img-element.ts
           │      │      ├─ no-page-custom-font.ts
           │      │      ├─ no-script-component-in-head.ts
           │      │      ├─ no-styled-jsx-in-document.ts
           │      │      ├─ no-sync-scripts.ts
           │      │      ├─ no-title-in-document-head.ts
           │      │      ├─ no-typos.ts
           │      │      └─ no-unwanted-polyfillio.ts
           │      │
           │      └─ configs (4プリセット)
           │             ├─ recommended-legacy
           │             ├─ core-web-vitals-legacy
           │             ├─ recommended
           │             └─ core-web-vitals
           │
           └─ utils/
                  ├─ define-rule.ts
                  ├─ node-attributes.ts
                  ├─ url.ts
                  └─ get-root-dirs.ts
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ソースコード ────────▶ ESLint + プラグイン ───────────▶ リント結果
                              │
eslint.config.js ───▶ ルールセット選択 ─────────────▶ 適用ルール一覧
                              │
AST (抽象構文木) ───▶ 各ルールの検査関数 ───────────▶ エラー/警告
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/eslint-plugin-next/src/index.ts` | ソース | プラグインのメインエクスポート |
| define-rule.ts | `packages/eslint-plugin-next/src/utils/define-rule.ts` | ソース | ルール定義ヘルパー |
| node-attributes.ts | `packages/eslint-plugin-next/src/utils/node-attributes.ts` | ソース | ASTノード属性操作 |
| url.ts | `packages/eslint-plugin-next/src/utils/url.ts` | ソース | URL処理ユーティリティ |
| get-root-dirs.ts | `packages/eslint-plugin-next/src/utils/get-root-dirs.ts` | ソース | ルートディレクトリ取得 |
| google-font-display.ts | `packages/eslint-plugin-next/src/rules/google-font-display.ts` | ソース | Google Fontsのfont-displayチェック |
| no-img-element.ts | `packages/eslint-plugin-next/src/rules/no-img-element.ts` | ソース | img要素の代わりにnext/image推奨 |
| no-html-link-for-pages.ts | `packages/eslint-plugin-next/src/rules/no-html-link-for-pages.ts` | ソース | a要素の代わりにnext/link推奨 |
| inline-script-id.ts | `packages/eslint-plugin-next/src/rules/inline-script-id.ts` | ソース | インラインScriptにID必須チェック |
